// This code manages state...

var saveState = function() {
    console.info('saveState()');
    setCookie("displayedMessages", displayedMessages.toString(), 90);
    setCookie("viewedNotes", viewedNotes.toString(), 90);
    setCookie("viewedPhotos", viewedPhotos.toString(), 90);
    setCookie("heardVoices", heardVoices.toString(), 90);
    setCookie("unreadMessageCount", unreadMessageCount, 90);
    setCookie("helloMessage", helloMessage, 90);
    setCookie("conversationStarted", conversationStarted, 90);
    setCookie("storyBegins", storyBegins, 90);
    setCookie("restored", true, 90);

    // check for end game...
    for (var n=0; n < viewedNotes.length; n++)
        if (viewedNotes[n] == false)
            return;

    for (var p=0; p < viewedPhotos.length; p++)
        if (viewedPhotos[p] == false)
            return;

    for (var m=0; m < all_messages.length; m++)
        if (all_messages[m].amberMessage == true && all_messages[m].viewed == false)
            return;

    // for (var v=0; v < 3; v++)
    //     if (heardVoices[v] == false)
    //         return;

    // end game is ready...
    $(".notes-screen").hide();
    $(".photos-screen").hide();
    $(".screen").hide();
    $(".voice-screen").hide();

    $(".messages-screen").show();
    $("#message-list").append("<div class='alert alert-info'><b><em>Amber says: </em></b>Mikayala died December of 2016. But I didn't.<br/>I refused. I tolf my father. I got help. I lived.</br><br/>Mikayla was me. But she killed herself, and I became happy. There is a Mikayla in all of us, I believe.<br/>Some let her control what we do.<br/>Others refuse and get help. Like me. It wasn't worth it to let her win. It's not worth it.<br/><br/>The End</div>");

};

var restoreState = function() {
    console.info('restoreState()');
    if (document.cookie.length < 6) return;
    displayedMessages = JSON.parse("[" + getCookie("displayedMessages") + "]");
    viewedNotes = JSON.parse("[" + getCookie("viewedNotes") + "]");
    viewedPhotos = JSON.parse("[" + getCookie("viewedPhotos") + "]");
    heardVoices = JSON.parse("[" + getCookie("heardVoices") + "]");
    unreadMessageCount = getCookie("unreadMessageCount");
    helloMessage = (getCookie("helloMessage") === 'true');
    conversationStarted = (getCookie("conversationStarted") === 'true');
    storyBegins = (getCookie("storyBegins") === 'true');
    restored = (getCookie("restored") === 'true');

    //
    // Reload viewed messages from cookie...
    //
    for (var m=0; m < displayedMessages.length; m++) {
        setMessageViewed(displayedMessages[m]);
    }

    if (conversationStarted) {
        $("#closeMessages").hide();
        $("#messages").trigger('click');
    }

};

var setCookie = function (cname, cvalue, exdays) {
    console.info('setCookie name=' + cname);
    var d = new Date();
    d.setTime(d.getTime() + (exdays * 24 * 60 * 60 * 1000));
    var expires = "expires="+d.toUTCString();
    document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
};

var getCookie = function (cname) {
    var name = cname + "=";
    var ca = document.cookie.split(';');
    for(var i = 0; i < ca.length; i++) {
        var c = ca[i];
        while (c.charAt(0) === ' ') {
            c = c.substring(1);
        }
        if (c.indexOf(name) === 0) {
            return c.substring(name.length, c.length);
        }
    }
    return "";
};

var checkCookie = function (key) {
    var cookie = getCookie(key);
    var result = !(cookie === "");
    console.info('checkCookie: key=' + key + ', cookie=' + cookie.toString() + ', result=' + result.toString());
    return result;
};
